**************************************************************************************************
*******************LOCAL INCOME INEQUALITY AND HOUSEHOLD INDEBTEDNESS ****************************
*************************REGRESSION ANALYSIS *****************************************************
*************************DATE: JAN 2022 **********************************************************
*************************AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load data
use "G:\HILDA\Restricted\Wave 19\User Files\KimN\Inequality and HH debt\UnbalancedHH_analytical.dta", clear

//Global vars
global DemCovar "age age2 sex Luni Lkids Ladults Lmarried Lemp Lnilf Lselfemp Duni Dkids Dadults Dmarried Demp Dnilf Dselfemp"
global FinCovar "Lginc Dginc Lassets Dassets Lfinassets Dfinassets Lliqnworth Dliqnworth"
global MacroCovar "Lmedhp Dmedhp Lurate Durate Lmedinc Dmedinc Lmeddebt Dmeddebt"


//TABLE 3 
//Panel A: Effects on Investment Debt and Car Debt - by Income Quantile

*Investment debt
eststo m1: quietly xtreg Dinvdebttoinc c.Dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m3: quietly xtreg Dcardebttoinc c.Dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel B: Effects on Investment Debt and Car Debt - by Financial Prosperity

*Investment debt
eststo m2: quietly xtreg Dinvdebttoinc c.Dgini#i.Lselfrank i.Lselfrank $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m4: quietly xtreg Dcardebttoinc c.Dgini#i.Lselfrank i.Lselfrank $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)


//TABLE 4
//Panel A: Effects on Investment Debt and Car Debt - by Life Cycle

*Investment debt
eststo m1: quietly xtreg Dinvdebttoinc c.Dgini#i.Lageg i.Lageg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m3: quietly xtreg Dcardebttoinc c.Dgini#i.Lageg i.Lageg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel B: Effects on Investment Debt and Car Debt - by Housing Status

*Investment debt
eststo m2: quietly xtreg Dinvdebttoinc c.Dgini#i.Lhsa i.Lhsa $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m4: quietly xtreg Dcardebttoinc c.Dgini#i.Lhsa i.Lhsa $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//TABLE 5
//Panel A: Effects on Investment Debt and Car Debt - by Htm

*Investment debt
eststo m1: quietly xtreg Dinvdebttoinc c.Dgini#i.Lhtm i.Lhtm $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m4: quietly xtreg Dcardebttoinc c.Dgini#i.Lhtm i.Lhtm $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel B: Effects on Investment Debt and Car Debt - by Ability to Raise Money Easily

*Investment debt
eststo m2: quietly xtreg Dinvdebttoinc c.Dgini#i.Leasyraise i.Leasyraise $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m5: quietly xtreg Dcardebttoinc c.Dgini#i.Leasyraise i.Leasyraise $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel E: Effects on Investment Debt and Car Debt - by Financial Risk

*Investment debt
eststo m3: quietly xtreg Dinvdebttoinc c.Dgini#i.Lfinrisk i.Lfinrisk $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m6: quietly xtreg Dcardebttoinc c.Dgini#i.Lfinrisk i.Lfinrisk $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
